#include <bits/stdc++.h>

#define ll long long
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define watch(x) cout << (#x) << " : " << x << '\n'
#define boost ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

using namespace std;

const int N = 1e5 + 1;
int n, m;
vector <int> g[N];
vector <int> color(N, 0);
vector <int> p(N, -1);
vector <bool> can_visit(N, false);

void dfs(int v, int depth = 0) {
    if (!can_visit[v]) {
        cout << "NO\n"; exit(0);
    }
    color[v] = 1;
    for (auto to : g[v]) {
        if (color[to] == 1 && to == 1 && depth+1 == n) {
            vector <int> cycle;
            cycle.push_back(to);
            for (int i = v; i != to; i = p[i])
                cycle.push_back(i);
            cycle.push_back(to);
            reverse(all(cycle));
            cout << "YES\n";
            for (auto c : cycle)
                cout << c << ' ';
            exit(0);
        }
        if (!color[to])
            p[to] = v, dfs(to, depth+1), color[to] = 0;
    }
    color[v] = 2;
}

vector <bool> used(N, false);

void cnt(int v) {
    used[v] = true;
    for (auto to : g[v])
        if (!used[to])
            cnt(to);
}



vector <bool> vis(N, false);

void check(int v) {
    vis[v] = 1;
    for (auto to : g[v]) {
        if (can_visit[v])
            return;
        check(to);
        can_visit[v] = can_visit[v] | can_visit[to];
    }
}

void solve() {
    cin >> n >> m;
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        g[a].push_back(b);
    }
    if (m < n) {
        cout << "NO\n";
        return;
    }
    for (int i = 1; i <= n; i++) {
        if (g[i].empty()) {
            cout << "NO\n"; return;
        }
    }
    int cmp = 0;
    for (int i = 1; i <= n; i++)
        if (!used[i])
            cnt(i), cmp++;
    if (cmp > 1) {
        cout << "NO\n"; return;
    }
    can_visit[1] = true;
    for (int i = 1; i <= n; i++)
        if (!vis[i])
            check(i);

    dfs(1);
    cout << "NO\n";
}

main () {
    boost;
    solve();
    return 0;
}
